
markup.push({

	// MARK: known AU mappings

	IgnoredAUBlock: {
		ignoredAudioUnit: true
	},

	KnownAudioUnitMapping:
	{
		// apple effects
		"aufx.appl.bpas":	"AUBandpassBlock",				// Apple: AUBandpass
		"aufx.appl.dcmp":	"AUDynamicsProcessorBlock",		// Apple: AUDynamicsProcessor
		"aufx.appl.dely":	"AUDelayBlock",					// Apple: AUDelay
		"aufx.appl.dist":	"AUDistortionBlock",				// Apple: AUDistortion
		"aufx.appl.filt":	"AUFilterBlock",					// Apple: AUFilter
		"aufx.appl.greq":	"AUGraphicEQBlock",				// Apple: AUGraphicEQ
		"aufx.appl.hpas":	"AUHipassBlock",					// Apple: AUHipass
		"aufx.appl.hshf":	"AUHighShelfFilterBlock",			// Apple: AUHighShelfFilter
		"aufx.appl.lmtr":	"AUPeakLimiterBlock",				// Apple: AUPeakLimiter
		"aufx.appl.lpas":	"AULowpassBlock",					// Apple: AULowpass
		"aufx.appl.lshf":	"AULowShelfFilterBlock",			// Apple: AULowShelfFilter
		"aufx.appl.mcmp":	"AUMultibandCompressorBlock",		// Apple: AUMultibandCompressor
		"aufx.appl.mrev":	"AUMatrixReverbBlock",			// Apple: AUMatrixReverb
		"aufx.appl.nbeq":	"AUNBandEQBlock",					// Apple: AUNBandEQ
		"aufx.appl.nsnd":	"AUNetSendBlock",					// Apple: AUNetSend
		"aufx.appl.pmeq":	"AUParametricEQBlock",			// Apple: AUParametricEQ
		"aufx.appl.raac":	"IgnoredAUBlock",					// Apple: AURoundTripAAC 	- blocked
		"aufx.appl.rogr":	"IgnoredAUBlock",					// Apple: AURogerBeep 		- blocked
		"aufx.appl.sdly":	"IgnoredAUBlock",					// Apple: AUSampleDelay 	- blocked
		"aufx.appl.tmpt":	"AUPitchBlock",					// Apple: AUPitch
		"aufx.appl.nutp":	"AUNewPitchBlock",				// Apple: AUNewPitch - uses generic interface
		"aumu.appl.msyn":	"IgnoredAUBlock",					// Apple: AUMIDISynth 		- blocked, new in 10.11, AH3 doesn’t do MIDI commands
		"aufx.appl.rvb2":   "AUReverb2Block",					// Apple: AUReverb - seems to have no custom interface?

		"aufx.appl.vois":   "AUSoundIsolationBlock",			// New sound isloation AU
		
		// apple music effects
		"aumu.appl.dls ":	"AUDLSMusicDeviceBlock",			// Apple: DLSMusicDevice
		"aumu.appl.samp":	"AUSamplerBlock",					// Apple: AUSampler

		// apple generators
		"augn.appl.afpl":	"AUAudioFilePlayerBlock",			// Apple: AUAudioFilePlayer
		"augn.appl.nrcv":	"AUNetReceiveBlock",				// Apple: AUNetReceive
		"augn.appl.sspl":	"IgnoredAUBlock",					// Apple: AUScheduledSoundPlayer - blocked
		"augn.appl.ttsp":	"IgnoredAUBlock"					// Apple: AUSpeechSynthesis - blocked
	},


	// ----------------------------------------------------------------------
	// MARK: AU templates
    
    GenericAUBlock:
    {
        "+": "BlockTemplate",
        geNodeClass: "AHAudioUnitNode",
        gxIconPainter: "ImagePainter.block.plugin",
        gxLibraryIcon: "library.plugin",
        description: "Audio Unit Plugin",
        gxPopoverInfo: "GenericAUPopover",
        gxAllowTallTitle: true,
    },

	GenericAUPopover:
    {
		"+": "PopoverTemplate",
		//geDisplayName: "Audio Unit Plugin",
		gxLayout: [  
					"H:|-12-[self]-12-|",
				   	"V:|-12-[self]-12-|",
					"H:|-12-[auView(<=100@500)]-12-|", // Shrink to fit the view
				   	"V:|-37-[auView(<=100@500)]-8-[presetsGroup]-8-|"  // Shrink to fit the view
				   ],
		gxChildViews: {
			title: "PopoverTitle",
			onOff: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			auView: {
				nsClass: "GEAudioUnitView",
				gxBackPainter: "AudioUnitBack"
			}, 
		}
	},

    AudioUnitBack:
    {
        "+": "GroupViewBack",
        generic: {
            gxFillColor: "BackColor1",
         }
    },

    
	// ----------------------------------------------------------------------
	// MARK: Apple AU templates

	AppleAUPopover: {
		"+": "GenericAUPopover",
		gxTitle: "Apple Audio Unit"
	},

	AppleAUPopoverTrimTop: {
		"+": "AppleAUPopover",
		gxChildViews: {
			title: "PopoverTitle",
			onOff: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			// trimmed audio unit view
			auView: {
				nsClass: "GEAudioUnitView",
				gxBackPainter: "AudioUnitBack",
				borderInsets: "0,28,0,0"
			},
		}
	},

	AppleAUPopoverTrimAll: {
		"+": "AppleAUPopover",
		gxChildViews: {
			title: "PopoverTitle",
			onOff: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			// trimmed audio unit view
			auView: {
				nsClass: "GEAudioUnitView",
				gxBackPainter: "AudioUnitBack",
				borderInsets: "4,28,4,10"
			},
		}
	},

	AppleAUBlockTemplate: {
		"+": "GenericAUBlock",
		//geDisplayName:  Note: having no display name allows the node to provide it
        gxLibraryDescription: "",	// blank description for now
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},


	// ----------------------------------------------------------------------
	// MARK: apple AU blocks

	AUAudioFilePlayerBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUAudioFile Player",
        gxLibraryDescription: "Play and loop audio files",
		gxPopoverTitle: "Audio File Player",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUBandpassBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Pass only frequencies in a specified range",
		gxPopoverTitle: "Bandpass Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},
	
	AUDynamicsProcessorBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUDynamics Processor",
		gxLibraryDescription: "Reduce or expand audio's dynamic range",
		gxPopoverTitle: "Dynamics Processor",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimTop"
		}
	},

	AUDelayBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Delay audio & replay to create an echo",
		gxPopoverTitle: "Apple Delay",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUDistortionBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Distort audio with multiple settings",
		gxPopoverTitle: "Distortion",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUFilterBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Filter audio with multiple pass & shelf options",
		gxPopoverTitle: "Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUGraphicEQBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Fine-tune specific frequencies with 10 or 31 bands",
		gxPopoverTitle: "Graphic Equalizer",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUHipassBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Pass high audio frequencies",
		gxPopoverTitle: "Highpass Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUHighShelfFilterBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUHighShelf Filter",
		gxLibraryDescription: "Cut off high audio frequencies",
		gxPopoverTitle: "High Shelf Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUPeakLimiterBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Limit audio volume dynamically",
		gxPopoverTitle: "Peak Limiter",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AULowpassBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Pass low audio frequencies",
		gxPopoverTitle: "Lowpass Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AULowShelfFilterBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AULowShelf Filter",
		gxLibraryDescription: "Cut off low audio frequencies",
		gxPopoverTitle: "Low Shelf Filter",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUMultibandCompressorBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUMultiband Compressor",
		gxLibraryDescription: "Reduce or expand audio across multiple frequency ranges",
		gxPopoverTitle: "Multiband Compressor",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimTop"
		}
	},

	AUMatrixReverbBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Create a range of reverb effects",
		gxPopoverTitle: "Matrix Reverb",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUNBandEQBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Fine-tune up to 16 frequency ranges",
		gxPopoverTitle: "N-Band Equalizer",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},
	
	AUNetReceiveBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Receive audio from AUNetSend",
		gxPopoverTitle: "Network Receive",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUNetSendBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Send audio to AUNetReceive",
		gxPopoverTitle: "Network Send",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUParametricEQBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUParametric EQ",
		gxLibraryDescription: "Adjust a given frequency range's amplitude",
		gxPopoverTitle: "Parametric Equalizer",
		gxPopoverInfo: {
			"+": "AppleAUPopoverTrimAll"
		}
	},

	AUPitchBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Shift the audio's pitch",
		gxPopoverTitle: "Pitch",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUNewPitchBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Shift the audio's pitch",
		gxPopoverTitle: "New Pitch",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUReverb2Block: {
	   "+": "AppleAUBlockTemplate",
	   gxLibraryDescription: "Add reverb to audio",
	   gxPopoverTitle: "Reverb2",
	   gxPopoverInfo: {
		   "+": "AppleAUPopover"
	   }
   },

	AUSamplerBlock: {
		"+": "AppleAUBlockTemplate",
		gxLibraryDescription: "Add samples with a playable instrument",
		gxPopoverTitle: "Sampler",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUSoundIsolationBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "AUSound Isolation",
		gxLibraryDescription: "Isolate voice from background audio",
		gxPopoverTitle: "Sound Isolation",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	AUDLSMusicDeviceBlock: {
		"+": "AppleAUBlockTemplate",
		gxTitle: "DLSMusic Device",
		gxLibraryDescription: "Add samples to your audio",
		gxPopoverTitle: "Music Device",
		gxPopoverInfo: {
			"+": "AppleAUPopover"
		}
	},

	// --------------------------------------------------
	// MARK: generic AU view controls

	GenericAUSliderItem: {
		nsClass: "GXDrawView",
		gxLayout: [ "H:|-10-[label(160)]-[slider(190)]-[readout(110)]-10-|&alignCenterY",
				   	"V:|-4-[slider]-3-|" ],
		gxChildViews: {
			slider: {
				"+": "SliderView"
			},
			label: {
				"+": "LabelView.right.centery",
				axIsIgnored: false,
			},
			readout: {
				"+": "ReadoutView.centery",
				axIsIgnored: false,
			}
		}
	},

	GenericAUSwitchItem: {
		nsClass: "GXDrawView",
		gxLayout: [ "H:|-10-[label(160)]-[switch]-10-|&alignBaseline",
				   	"V:|-4-[switch]-3-|" ],
		gxChildViews: {
			switch: {
				"+": "SwitchView",
				gxForePainter: "SwitchPainter",
			},
			label: {
				"+": "LabelView.right.dark.size13",
				axIsIgnored: false,
			}
		}
	},

	GenericAUPopupMenuItem: {
		nsClass: "GXDrawView",
		gxLayout: [ "H:|-10-[label(160)]-[popupMenu(250)]-10-|&alignBaseline",
				   	"V:|-4-[popupMenu]-3-|" ],
		gxChildViews: {
			popupMenu: {
				"+": "PopupMenuTemplate",
				gxHideOnNilValue:false
			},
			label: {
				"+": "LabelView.right.dark.size13",
				axIsIgnored: false,
			}
		}
	},


});
